using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace WindowsApplication1
{
    public partial class frmTicTacToe : Form
    {
        public frmTicTacToe()
        {
            InitializeComponent();
        }

        Random myRandom = new Random();
        Label[] boxArray = new Label[9];
        bool xTurn;
        bool canClick = false;
        int numberClicks;
        String[] possibleWins = new String[8];
        bool gameOver;
        System.Media.SoundPlayer drawSound;
        System.Media.SoundPlayer winSound;



        private void frmTicTacToe_Load(object sender, EventArgs e)
        {
            //'establish array
            boxArray[0] = lblBox1;
            boxArray[1] = lblBox2;
            boxArray[2] = lblBox3;
            boxArray[3] = lblBox4;
            boxArray[4] = lblBox5;
            boxArray[5] = lblBox6;
            boxArray[6] = lblBox7;
            boxArray[7] = lblBox8;
            boxArray[8] = lblBox9;
            // possible wins
            possibleWins[0] = "012";
            possibleWins[1] = "345";
            possibleWins[2] = "678";
            possibleWins[3] = "036";
            possibleWins[4] = "147";
            possibleWins[5] = "258";
            possibleWins[6] = "048";
            possibleWins[7] = "246";
            // clear boxes
            for (int i = 0; i < 9; i++)
                boxArray[i].Text = "";
            lblMessage.Text = "Game Stopped";
            grpFirst.Enabled = false;
            grpComputer.Enabled = false;
            drawSound = new System.Media.SoundPlayer(Application.StartupPath + "\\beep.wav");
            winSound = new System.Media.SoundPlayer(Application.StartupPath + "\\tada.wav");
        }

        private void btnExit_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void btnStartStop_Click(object sender, EventArgs e)
        {
            if (btnStartStop.Text == "Start Game")
            {
                btnStartStop.Text = "Stop Game";
                grpPlayers.Enabled = false;
                grpFirst.Enabled = false;
                grpComputer.Enabled = false;
                btnExit.Enabled = false;
                xTurn = true;
                lblMessage.Text = "X's Turn";
                // reset boxes
                for (int i = 0; i < 9; i++)
                {
                    boxArray[i].Text = "";
                    boxArray[i].BackColor = Color.White;
                }
                canClick = true;
                numberClicks = 0;
                gameOver = false;
                if (rdoComputerFirst.Checked)
                    ComputerTurn();
            }
            else
            {
                btnStartStop.Text = "Start Game";
                if (!gameOver)
                    lblMessage.Text = "Game Stopped";
                grpPlayers.Enabled = true;
                if (rdoOnePlayer.Checked)
                {
                  grpFirst.Enabled = true;
                  grpComputer.Enabled = true;
                }
                btnExit.Enabled = true;
                canClick = false;
            }
        }

        private void lblBox_Click(object sender, EventArgs e)
        {
            String whoWon = "";
            int i;
            if (canClick)
            {
                // see which box is clicked
                Label clickedBox;
                clickedBox = (Label) sender;
                // last digit of name (-1) is index
                i = Convert.ToInt32(clickedBox.Name[clickedBox.Name.Length - 1].ToString()) - 1;
                // if already clicked then exit
                if (boxArray[i].Text != "")
                    return;
                numberClicks++;
                if (xTurn)
                {
                    boxArray[i].Text = "X";
                    xTurn = false;
                    lblMessage.Text = "O's Turn";
                }
                else
                {
                    boxArray[i].Text = "O";
                    xTurn = true;
                    lblMessage.Text = "X's Turn";
                }
                // check for win - will establish a value for WhoWon
                whoWon = CheckForWin();
                if (whoWon != "")
                {
                    winSound.Play();
                    lblMessage.Text = whoWon + " wins!";
                    gameOver = true;
                    btnStartStop.PerformClick();
                    return;
                }
                else if (numberClicks == 9)
                {
                    // draw
                    drawSound.Play();
                    lblMessage.Text = "It's a draw!";
                    gameOver = true;
                    btnStartStop.PerformClick();
                    return;
                }
                if (rdoOnePlayer.Checked)
                    if ((xTurn && rdoComputerFirst.Checked) || (!xTurn && rdoYouFirst.Checked))
                        ComputerTurn();
            }
        }

        private String CheckForWin()
        {
            String winner = "";
            int[] boxNumber = new int[3];
            String[] mark = new String[3];
            // check all possible for wins
            for (int i = 0; i < 8; i++)
            {
                for (int j = 0; j < 3; j++)
                {
                    boxNumber[j] = Convert.ToInt32(possibleWins[i][j].ToString());
                    mark[j] = boxArray[boxNumber[j]].Text;
                }
                if (mark[0] == mark[1] && mark[0] == mark[2] && mark[1] == mark[2] && mark[0] != "")
                {
                    // we have a winner
                    winner = mark[0];
                    for (int j = 0; j < 3; j++)
                        boxArray[boxNumber[j]].BackColor = Color.Red;
                }
            }
            return (winner);
        }

        private void rdoOnePlayer_Click(object sender, EventArgs e)
        {
            grpFirst.Enabled = true;
            grpComputer.Enabled = true;

        }

        private void rdoTwoPlayers_Click(object sender, EventArgs e)
        {
            grpFirst.Enabled = false;
            grpComputer.Enabled = false;
        }

        private void ComputerTurn()
        {
            int selectedBox;
            int i, n;
            int j, k;
            String computerMark, playerMark, markToFind;
            int[] boxNumber = new int[3];
            String[] mark = new String[3];
            int emptyBox;
            int[] bestMoves = { 4, 0, 2, 6, 8, 1, 3, 5, 7 };

            if (rdoRandom.Checked)
            {
                // random logic
                // put mark in Nth available square
                n = myRandom.Next(9 - numberClicks) + 1;
                i = 0;
                for (selectedBox = 0; selectedBox < 9; selectedBox++)
                {
                    if (boxArray[selectedBox].Text == "")
                        i++;
                    if (i == n)
                        break;
                }
                // put mark in SelectedBox
                lblBox_Click(boxArray[selectedBox], null);
            }
            else
            {
                // smart computer
                // determine who has what mark
                if (rdoComputerFirst.Checked)
                {
                    computerMark = "X";
                    playerMark = "O";
                }
                else
                {
                    computerMark = "O";
                    playerMark = "X";
                }
                // Step 1 (K = 1) - check for win - see if two boxes hold computer mark and one is empty
                // Step 2 (K = 2) - check for block - see if two boxes hold player mark and one is empty
                for (k = 1; k <= 2; k++)
                {
                    if (k == 1)
                        markToFind = computerMark;
                    else
                        markToFind = playerMark;
                    for (i = 0; i < 8; i++)
                    {
                        n = 0;
                        emptyBox = 0;
                        for (j = 0; j < 3; j++)
                        {
                            boxNumber[j] = Convert.ToInt32(possibleWins[i][j].ToString());
                            mark[j] = boxArray[boxNumber[j]].Text;
                            if (mark[j] == markToFind)
                                n++;
                            else if (mark[j] == "")
                                emptyBox = boxNumber[j];
                        }
                        if (n == 2 && emptyBox != 0)
                        {
                            // mark empty box to win (K = 1) or block (K = 2)
                            lblBox_Click(boxArray[emptyBox], null);
                            return;
                        }
                    }
                }
                // Step 3 - find next best move
                for (i = 0; i < 9; i++)
                {
                    if (boxArray[bestMoves[i]].Text == "")
                    {
                        lblBox_Click(boxArray[bestMoves[i]], null);
                        return;
                    }
                }
            }
        }


    }
}